using System;
using Server;

namespace Server.Items
{
	public class LevelArcaneShield : LevelWoodenKiteShield
	{
		public override int LabelNumber{ get{ return 1061101; } } // Arcane Shield 
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public LevelArcaneShield()
		{
			ItemID = 0x1B78;
			Hue = 0x556;
			Attributes.NightSight = 1;
			Attributes.SpellChanneling = 1;
			Attributes.DefendChance = 15;
			Attributes.CastSpeed = 1;
         Attributes.BonusHits = 20;
         Attributes.Luck = 250;
         
         SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
         SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 );
         SkillBonuses.SetValues( 2, SkillName.Parry, 10.0 );
		}
      
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>Indisturbable meditation<basefont color=White>" );
		}

		public LevelArcaneShield( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Attributes.NightSight == 0 )
				Attributes.NightSight = 1;
            
			if ( version == 0 )
         {
            Attributes.BonusHits = 20;
            Attributes.Luck = 250;
            SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
            SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 );
            SkillBonuses.SetValues( 2, SkillName.Parry, 10.0 );
         }
		}
	}
}